% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.radviz.R
\name{plot.radviz}
\alias{plot.radviz}
\title{A Plotting Function for the Radviz Object}
\usage{
\method{plot}{radviz}(
  x,
  main = NULL,
  anchors.only = TRUE,
  label.color = NULL,
  label.size = NULL,
  point.color,
  point.shape,
  point.size,
  add,
  ...
)
}
\arguments{
\item{x}{a radviz object as produced by \code{\link{do.radviz}}}

\item{main}{[Optional] a title to the graph, displayed on top}

\item{anchors.only}{by default only plot the anchors so that other methods can easily be chained}

\item{label.color}{the color of springs for visualization}

\item{label.size}{the size of labels}

\item{point.color}{deprecated, use \code{\link{geom_point}} instead}

\item{point.shape}{deprecated, use \code{\link{geom_point}} instead}

\item{point.size}{deprecated, use \code{\link{geom_point}} instead}

\item{add}{deprecated, use \code{\link{geom_point}} instead}

\item{...}{further arguments to be passed to or from other methods (not implemented)}
}
\value{
the internal ggplot2 object, allowing for extra geoms to be added
}
\description{
Plots the Dimensional Anchors and projected data points in a 2D space.
}
\details{
by default the plot function only shows the anchors. Extra geoms are required to display the data
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv)
plot(rv,anchors.only=FALSE)

library(ggplot2)
## should look the same as before
plot(rv)+geom_point()
plot(rv)+geom_point(aes(color=Species))

}
\author{
Yann Abraham
}
