% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeD10.R
\name{computeD10}
\alias{computeD10}
\title{Compute D10}
\usage{
computeD10(pars)
}
\arguments{
\item{pars}{parameters (alpha, beta) in equation y = exp(-alpha * x - beta * x ^ 2)}
}
\description{
This function computes the radiation dose at which only 10% of cancer cells survive under the exponential model SF = exp(-alpha * D - beta * D ^ 2) given alpha and beta, where D is the radiation dose given and SF is the fraction of cells surviving
}
\details{
The units of the returned dose are the inverses of the units of the alpha and beta passed in.
}
\examples{
computeD10(c(0.2, 0.1))
}
