% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{randomizeCoords}
\alias{randomizeCoords}
\title{Randomize map coordinates}
\usage{
randomizeCoords(map, optimization_number = 1, table_dist_factor = 2)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The map optimization number to randomize}

\item{table_dist_factor}{The expansion factor for the box size in which
points are randomized.}
}
\value{
Returns an updated map object
}
\description{
Moves map coordinates back into random starting conditions, as performed
before each optimization run. The maximum table distance is calculated
then points are randomized in a box with side length equal to maximum
table distance multiplied by \code{table_dist_factor}
}
\seealso{
Other map optimization functions: 
\code{\link{RacOptimizer.options}()},
\code{\link{make.acmap}()},
\code{\link{moveTrappedPoints}()},
\code{\link{optimizeMap}()},
\code{\link{relaxMapOneStep}()},
\code{\link{relaxMap}()}
}
\concept{map optimization functions}
