% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_diagnostics_bootstrap_blobs.R
\name{bootstrapBlobs}
\alias{bootstrapBlobs}
\title{Calculate bootstrap blob data for an antigenic map}
\usage{
bootstrapBlobs(
  map,
  conf.level = 0.68,
  smoothing = 6,
  gridspacing = 0.25,
  antigens = TRUE,
  sera = TRUE,
  method = "ks"
)
}
\arguments{
\item{map}{The acmap data object}

\item{conf.level}{The proportion of positional variation captured by each blob}

\item{smoothing}{The amount of smoothing to perform when performing the
kernel density estimate, larger equates to more smoothing}

\item{gridspacing}{grid spacing to use when calculating blobs, smaller values
will produce more accurate blobs with smoother edges but will take longer
to calculate.}

\item{antigens}{Should blobs be calculated for antigens}

\item{sera}{Should blobs be calculated for sera}

\item{method}{One of "MASS", the default, or "ks", specifying the algorithm to
use when calculating blobs in 2D. 3D will always use ks::kde.}
}
\value{
Returns an acmap object that will then show the corresponding bootstrap
blobs when viewed or plotted.
}
\description{
This function takes a map for which the function \code{bootstrapMap()} has already
been applied and draws contour blobs for each point illustrating how point
position varies in each bootstrap repeat. The blobs are calculated using
kernal density estimates according to these point distribution and drawn
so as to encompass a given proportion of this variation according to the
parameter \code{conf.level}. A \code{conf.level} set at 0.95 for example will draw
blobs that are calculated to encompass 95\% of the positional variation seen
in the bootstrap repeats. Note however that the accuracy of these estimates
will depend on the number of bootstrap repeats performed, for example whether
100 or 1000 repeats were performed in the initial calculations using
\code{boostrapMap()}.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
