% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMSdataCode.R
\name{grabAccessionData}
\alias{grabAccessionData}
\title{Get arbitrary metadata from an mzML file by accession number}
\usage{
grabAccessionData(filename, accession_number)
}
\arguments{
\item{filename}{The name of the file for which metadata is requested. Both
absolute and relative paths are acceptable.}

\item{accession_number}{The HUPO-PSI accession number for the metadata to
be extracted. These accession numbers are typically of the form MS:#######
and the full list can be found and searched at
https://raw.githubusercontent.com/HUPO-PSI/psi-ms-CV/master/psi-ms.obo.}
}
\value{
A data frame with the name and value of the parameter requested,
as deduced from the XML tag attributes corresponding to the accession
number.
}
\description{
Get arbitrary metadata from an mzML file by accession number
}
\examples{
library(RaMS)
\dontshow{data.table::setDTthreads(2)}
sample_dir <- system.file("extdata", package = "RaMS")
sample_file <- list.files(sample_dir, full.names=TRUE)[3]
# Get ion injection time
iit_df <- grabAccessionData(sample_file, "MS:1000927")
# Manually create TIC
int_df <- grabAccessionData(sample_file, "MS:1000285")
rt_df <- grabAccessionData(sample_file, "MS:1000016")
tic <- data.frame(rt=rt_df$value, int=int_df$value)
plot(tic$rt, tic$int, type = "l")
}
