% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVenn.R, R/Heatmap.R
\docType{methods}
\name{setmap}
\alias{setmap}
\alias{setmap,Venn-method}
\title{Draw a clustered heatmap showing presence/absence of the elements.}
\usage{
\S4method{setmap}{Venn}(venn, slice = "all", element_clustering = TRUE,
  set_clustering = TRUE, method = "average", legend = TRUE,
  title = NA, element_fontsize = 10, set_fontsize = 10)
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) The names or the indices of sets of interest. Default
is "all", meaning the union will be calculated for all the sets.}

\item{element_clustering}{(Optional) Boolean values determining if elements
should be clustered.}

\item{set_clustering}{(Optional) Boolean values determining if sets should be
clustered.}

\item{method}{(Optional) Clustering method used. Accepts the same values as
\code{\link[stats]{hclust}}.}

\item{legend}{(Optional) Boolean values determining if the legend should be
drawn.}

\item{title}{(Optional) Title of the heatmap.}

\item{element_fontsize}{(Optional) Font size of the elements.}

\item{set_fontsize}{(Optional) Font size of the sets.}
}
\value{
Presence/absence heatmap of the sets.
}
\description{
This function is based on the package 'pheatmap'. \code{\link{ggvenn}}
function is useful for 2-3 sets, if you need to show interactions between
many sets, you can show the presence/absence of the elements among all the
sets and cluster both the sets and the elements based on Jaccard distances.
}
\examples{
venn = Venn(list(letters[1:10], letters[3:12], letters[6:15], letters[9:16],
letters[15:25], letters[12:20]))
setmap(venn)
setmap(venn, slice = 1:4, element_clustering = FALSE, set_clustering = FALSE)
}
