\name{classify_model}
\alias{classify_model}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
makes predictions from a train_model() object.
}
\description{
Uses a trained model from the \code{\link{train_model}} function to classify new data.
}
\usage{
classify_model(corpus, model, s=0.01, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type matrix_container generated by the \code{\link{create_corpus}} function.
}
  \item{model}{
Slot for trained SVM, Naive Bayes, boosting, bagging, RandomForests, glmnet, decision tree, neural network, or maximum entropy model generated by \code{\link{train_model}}.
}
  \item{s}{
Penalty parameter lambda for \pkg{glmnet} classification.
}
  \item{\dots}{
Additional parameters to be passed into the \code{predict} function of any algorithm.
}
}
\details{
Only one model may be passed in at a time for classification. See \code{\link{train_models}} and \code{\link{classify_models}} to train and classify using multiple algorithms.
}
\value{
Returns a data frame of predicted codes and probabilities for the specified algorithm.
}
\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}

\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
maxent_model <- train_model(corpus,"MAXENT")
svm_model <- train_model(corpus,"SVM")
maxent_results <- classify_model(corpus,maxent_model)
svm_results <- classify_model(corpus,svm_model)
}

\keyword{method}
