% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/advector.R
\name{Tape}
\alias{Tape}
\alias{MakeTape}
\alias{$.Tape}
\alias{print.Tape}
\alias{TapeConfig}
\alias{DataEval}
\alias{GetTape}
\title{The AD tape}
\usage{
MakeTape(f, x)

\method{$}{Tape}(x, name)

\method{print}{Tape}(x, ...)

TapeConfig(
  comparison = c("NA", "forbid", "tape", "allow"),
  atomic = c("NA", "enable", "disable"),
  vectorize = c("NA", "disable", "enable")
)

DataEval(f, x)

GetTape(obj, name = c("ADFun", "ADGrad", "ADHess"), warn = TRUE)
}
\arguments{
\item{f}{R function}

\item{x}{numeric vector}

\item{name}{Name of a tape method}

\item{...}{Ignored}

\item{comparison}{Set behaviour of AD comparison (\code{">"},\code{"=="}, etc).}

\item{atomic}{Set behaviour of AD BLAS operations (notably matrix multiply).}

\item{vectorize}{Enable/disable AD vectorized 'Ops' and 'Math'.}

\item{obj}{Output from \code{MakeADFun}}

\item{warn}{Give warning if \code{obj} was created using another DLL?}
}
\value{
Object of class \code{"Tape"}.
}
\description{
The AD tape as an R function
}
\details{
A 'Tape' is a representation of a function that accepts \emph{fixed size} numeric input and returns \emph{fixed size} numeric output.
The tape can be constructed using \code{F <- MakeTape(f, x)} where \code{f} is a standard \emph{differentiable} R function (or more precisely: One using only functions that are documented to work for AD types).
Having constructed a tape F, a number of methods are available:

Evaluation:
\itemize{
\item Normal function evaluation 'F(x)' for numeric input.
\item AD evaluation 'F(x)' as part of other tapes.
\item Jacobian calculations using 'F$jacobian(x)'.
}

Transformation:
\itemize{
\item Get new tape representing the Jacobian using \code{F$jacfun()}.
\item Get new tape representing the sparse Jacobian using \code{F$jacfun(sparse=TRUE)}.
\item Get new tape representing the Laplace approximation using \code{F$laplace(indices)}.
\item Get new tape representing the Saddle Point approximation using \code{F$laplace(indices,SPA=TRUE)}.
\item Get new tape representing the optimum (minimum) wrt \code{indices} by \code{F$newton(indices)}.
\item Get a 'shared pointer' representation of a tape using \code{F$atomic()}.
\item Get tape of a single node by \code{F$node(index)} (mainly useful for derivative debugging).
}

Modification:
\itemize{
\item Simplify internal representation of a tape using \code{F$simplify()}.
}

Extract tape information:
\itemize{
\item Get internal parameter vector by \code{F$par()}.
\item Get computational graph by \code{F$graph()}.
\item Print the tape by \code{F$print()}.
\item Get internal arrays as a \code{data.frame} by \code{F$data.frame()}.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{$}: Get a tape method.

\item \code{print(Tape)}: Print method

}}
\section{Functions}{
\itemize{
\item \code{MakeTape()}: Generate a 'Tape' of an R function.

\item \code{TapeConfig()}: Global configuration parameters of the tape (experts only!)
\bold{comparison} By default, AD comparison gives an error
(\code{comparison="forbid"}).
This is the safe and recommended behaviour, because comparison is a
non-differentiable operation. If you are building a tape that
requires indicator functions e.g. \code{f(x)*(x<0)+g(x)*(x>=0)}
then use \code{comparison="tape"} to add the indicators to the
tape. A final option \code{comparison="allow"} exists for
testing/illustration purposes. Do not use.

\item \code{DataEval()}: Move a chunk of data from R to the tape by evaluating a normal R function (replaces TMB functionality 'DATA_UPDATE').

\item \code{GetTape()}: Extract tapes from a model object created by \code{MakeADFun}.

}}
\examples{
F <- MakeTape(prod, numeric(3))
show(F)
F$print()
H <- F$jacfun()$jacfun() ## Hessian tape
show(H)
#### Handy way to plot the graph of F
if (requireNamespace("igraph")) {
   G <- igraph::graph_from_adjacency_matrix(F$graph())
   plot(G, vertex.size=17, layout=igraph::layout_as_tree)
}
## Taped access of an element of 'rivers' dataset
F <- MakeTape(function(i) DataEval( function(i) rivers[i] , i), 1 )
F(1)
F(2)
}
