% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBSOption.R
\name{GBSOption}
\alias{GBSOption}
\title{Generalized Black-Scholes (GBS) Option Pricing Model}
\usage{
GBSOption(S, X, T2M, r, b, sigma, type = "call")
}
\arguments{
\item{S}{numeric, the current stock price (also known as the underlying asset price).}

\item{X}{numeric, the strike price of the option.}

\item{T2M}{numeric, the time to maturity (in years). Previously denoted as T.}

\item{r}{numeric, the risk-free interest rate (annualized).}

\item{b}{numeric, the cost of carry, b = r - q for dividend paying assets,
where q is the dividend yield rate.}

\item{sigma}{numeric, the volatility of the underlying asset (annualized).}

\item{type}{character, the type of option to evaluate, either "call" or "put".
Default is "call".}
}
\value{
A list containing the following elements:
\itemize{
\item \code{price}: The price of the option.
\item \code{delta}: The sensitivity of the option's price to a change in the
price of the underlying asset.
\item \code{gamma}: The rate of change in the delta with respect to changes
in the underlying price.
\item \code{vega}: The sensitivity of the option's price to the volatility of
the underlying asset.
\item \code{theta}: The sensitivity of the option's price to the passage of time.
\item \code{rho}: The sensitivity of the option's price to the interest rate.
}
}
\description{
Computes the price and Greeks of European call and put options using the
Generalized Black-Scholes model.
}
\examples{
GBSOption(S = 100, X = 100, T2M = 1, r = 0.05, b = 0.02, sigma = 0.2, type = "call")

}
