% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_PerfSummary.R
\name{chart_PerfSummary}
\alias{chart_PerfSummary}
\title{\code{chart_PerformanceSummary}}
\usage{
chart_PerfSummary(
  ret = ret,
  geometric = TRUE,
  main = "Cumulative Returns and Drawdowns",
  linesize = 1.25
)
}
\arguments{
\item{ret}{Wide dataframe univariate or multivariate of percentage returns.}

\item{geometric}{Use geometric returns TRUE or FALSE.}

\item{main}{Chart title.}

\item{linesize}{Size of lines in chart and legend.}
}
\value{
Cumulative performance and drawdown charts.
}
\description{
Multi Asset Display of Cumulative Performance and Drawdowns
}
\examples{
df <- dflong \%>\% dplyr::filter(series \%in\% c("CL01","CL12","CL36"))
ret <- returns(df=df,retType="rel",period.return=1,spread=TRUE)
ret <-data.frame(rolladjust(x=ret,commodityname=c("cmewti"),rolltype=c("Last.Trade")))
chart_PerfSummary(ret=ret, geometric=TRUE, main="Cumulative Returns and Drawdowns",linesize=1.25)
}
\author{
Philippe Cote
}
