% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superClass.R
\name{predict.superClass}
\alias{predict.superClass}
\title{Predict a raster map based on a superClass model fit.}
\usage{
\method{predict}{superClass}(object, img, predType = "raw",
  filename = NULL, datatype = "INT2U", ...)
}
\arguments{
\item{object}{superClass object}

\item{img}{Raster object. Layernames must correspond to layernames used to train the superClass model, i.e. layernames in the original raster image.}

\item{predType}{Character. Type of the final output raster. Either "raw" for class predictions or "prob" for class probabilities. Class probabilities are not available for all classification models (\link[caret]{predict.train}).}

\item{filename}{Character or NULL. Filename for output raster file.}

\item{datatype}{Datatype of output raster file.}

\item{...}{Further arguments passed to writeRaster.}
}
\description{
useful to separate model fitting from spatial prediction, which can take some time.
}
\examples{
## Load training data
data(rlogo)
train <- readRDS(system.file("external/trainingPoints.rds", package="RStoolbox"))

## Fit classifier 
SC       <- superClass(rlogo, trainData = train, responseCol = "class", 
              model = "rf", tuneLength = 1, predict = FALSE)

map <- predict(SC, rlogo)
}
