% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GetFeeds.R
\name{GetFeeds}
\alias{GetFeeds}
\title{Get Data Feed Detail for a Report Suite(s)}
\usage{
GetFeeds(reportsuite.ids, start.time = "", end.time = "", status = c())
}
\arguments{
\item{reportsuite.ids}{Report suite id (or list of report suite ids)}

\item{start.time}{Beginning of time period you want to check}

\item{end.time}{End of time period you want to check}

\item{status}{Character vector/list of statuses to filter by (processing/delivered/upload_error/no_data)}
}
\value{
Data frame
}
\description{
Returns a list of data feeds for the specified report suites,
including delivery status. Note that the difference between start.time and end.time can be no
more than 48 hours.
}
\details{
This function requires having a character vector with one or more valid Report Suites specified. All other function arguments are optional.
}
\examples{
\dontrun{

#Get info for all feeds for a report suite in past day
feeds <- GetFeeds("zwitchdev")

#Get info for all feeds for a 48-hour period
feeds2 <- GetFeeds("zwitchdev", "2014-12-02 05:00:00", "2014-12-03 05:00:00")

}
}

