% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueTrended.R
\name{QueueTrended}
\alias{QueueTrended}
\title{Run a Trended Report}
\usage{
QueueTrended(reportsuite.id, date.from, date.to, metrics, elements, top = 0,
  start = 0, selected = c(), search = c(), search.type = "or",
  date.granularity = "day", segment.id = "", segment.inline = "",
  classification = character(0), anomaly.detection = FALSE,
  data.current = FALSE, expedite = FALSE, interval.seconds = 5,
  max.attempts = 120, validate = TRUE, enqueueOnly = FALSE)
}
\arguments{
\item{reportsuite.id}{Report suite id}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{metrics}{List of metrics to include in the report}

\item{elements}{List of elements to include in the report}

\item{top}{List of numbers to limit the number of rows to include (top X). eg. c(10,5)}

\item{start}{Start row if you do not want to start at #1}

\item{selected}{List of specific items (of the first element) to include in the report - e.g. c("www:home","www:search","www:about")}

\item{search}{List of keywords for the first specified element - e.g. c("contact","about","shop").
search overrides anything specified using selected}

\item{search.type}{String specifying the search type: 'and', or, 'or' 'not' (defaults to 'or')}

\item{date.granularity}{Time granularity of the report (year/month/week/day/hour), default to 'day'}

\item{segment.id}{Id(s) of Adobe Analytics segment to retrieve the report for}

\item{segment.inline}{Inline segment definition}

\item{classification}{SAINT classification to use in place of first element. Need to specify element AND classification.}

\item{anomaly.detection}{Set to TRUE to include forecast data (only valid for day granularity with small date ranges)}

\item{data.current}{TRUE or FALSE - whether to include current data for reports that include today's date}

\item{expedite}{Set to TRUE to expedite the processing of this report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{whether to submit report definition for validation before requesting the data.}

\item{enqueueOnly}{only enqueue the report, don't get the data. returns report id, which you can later use to get the data}
}
\value{
Data frame or report id, if enqueueOnly is TRUE
}
\description{
A QueueTrended report is a report where a single metric is
retrieved, broken down by an element such as page, eVar, prop, etc. and with
a time component. Within the 'element' list, either the "Top X" number of
elements can be received or you can specify the specific elements you are
interested in (such as 3 specific page names).
}
\details{
The QueueTrended report is analogous to pulling a "trended"
report within Adobe Reports & Analytics, but without the limitation of
only 5 elements as in the Adobe Reports & Analytics interface.

Because of the Reporting API structure, this function first requests the
report, then checks the reporting queue to see if the report is completed,
and when the report returns as "done" pulls the report from the API. This
checking process will occur up to the specified number of times (default 120),
with a delay between status checks (default 5 seconds). If the report does not
return as "done" after the number of tries have completed, the function will return
an error message.

Note: Because of the multiple argument type ("top" and "start" OR "selected"),
keyword arguments are generally needed towards the end of the function call
instead of just positional arguments.
}
\examples{
\dontrun{
report.data <- QueueTrended("your_report_suite",
                            "2014-01-01",
                            "2014-01-07",
                            c("visits","uniquevisitors","pageviews","event10"),
                            c("page","geoCountry","geoCity")
                            )
}
}
