% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.synthesis}
\alias{.synthesis}
\title{Internal function for generating synthetic single-cell
data through simulation of tumor growth and evolution.}
\usage{
.synthesis(sample, site, evolutionSteps, mutationRate = 0.01,
  advantageIncreaseRatio = 1, advantageDecreaseRatio = 10,
  advantageKeepRatio = 100, advantageIncreaseStep = 0.01,
  advantageDecreaseStep = 0.01, mvRate = 0.5, fpRate = 0.2,
  fnRate = 0.1, seed = -1L)
}
\arguments{
\item{sample}{Number of samples}

\item{site}{Number of sites}

\item{evolutionSteps}{Number of non-root nodes in the evolutionary tree 
to be generated.}

\item{mutationRate}{The rate of mutation on each evolutionary step in evolutionary tree synthesis.}

\item{advantageIncreaseRatio, advantageDecreaseRatio, advantageKeepRatio}{A child node
in the evolutionary tree is chosen for increase/decrease/keep its parent advantage with
probabilities proportional to \code{advantage.increase.ratio}/\code{advantage.decrease.ratio}/\code{advantage.keep.ratio}.}

\item{advantageIncreaseStep, advantageDecreaseStep}{The amount of 
increasing or decreasing the advantage of a cell relative to its parent.}

\item{mvRate}{Rate of missing value to be added to the resulting sequences.}

\item{fpRate, fnRate}{Rate of false positive (0 -> 1) and false negative (1 -> 0)
in the sequences.}

\item{seed}{The seed for randomization.}
}
\value{
The function returns a list. The list consists of 
  \itemize{
    \item \code{sequence}: A data frame representing
      result of sequencing. The data frame has a row for each locus and a column for each sample.
    \item \code{true.sequence}: The actual sequence for the sample before adding errors and missing values.
    \item \code{true.clone}: A list that stores index of sampled cells for each node in the evolutionary tree.
    \item \code{true.tree}: The evolutionary tree that the samples are sampled from. It is a data frame
      with \code{src}, \code{dest}, and \code{len} columns representing source, destination and weight of edges of the tree,
      respectively.
 }
}
\description{
Internal function for generating synthetic single-cell
data through simulation of tumor growth and evolution.
}
