% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluate.R
\name{SSLDataFrameToMatrices}
\alias{SSLDataFrameToMatrices}
\title{Convert data.frame to matrices for semi-supervised learners}
\usage{
SSLDataFrameToMatrices(model, D)
}
\arguments{
\item{model}{Formula object with model}

\item{D}{data.frame object with objects}
}
\value{
list object with the following objects:
\item{X}{design matrix of the labeled data}
\item{X_u}{design matrix of the unlabeled data}
\item{y}{integer vector indicating the labels of the labeled data}
\item{classnames}{names of the classes corresponding to the integers in y}
}
\description{
Given a formula object and a data.frame, extract the design matrix X for the labeled observations, X_u for the unlabeled observations and y for the labels of the labeled observations. Note: always removes the intercept
}
\seealso{
Other RSSL utilities: \code{\link{LearningCurveSSL}},
  \code{\link{add_missinglabels_mar}},
  \code{\link{df_to_matrices}},
  \code{\link{measure_accuracy}},
  \code{\link{missing_labels}},
  \code{\link{split_dataset_ssl}},
  \code{\link{split_random}}, \code{\link{true_labels}}
}
