\name{SQLite}
\alias{SQLite}
\alias{SQLiteDriver}
\title{
  Instantiate the SQLite engine from the current R/S-Plus session.
}
\description{
This function creates and initializes the SQLite engine.
It returns an object that allows you to connect to the SQLite 
embedded engine.
}
\usage{
SQLite(max.con = 16, fetch.default.rec = 500, force.reload = F)
}
\arguments{
\item{max.con }{
  maximum number of connections that may be open at one time.
  This can be up to 100, a limit defined at compilation time.
  Note that since the SQLite engine is embedded (i.e., a set of C 
  functions within the R/S-Plus process) connections consume very
  little resources.
  }
\item{fetch.default.rec}{
  number of records to fetch at one time from the database.
  (The \code{fetch} method uses this number as a default.)
  }
\item{force.reload}{
  should the package code be reloaded (reinitialized)?
  Setting this to \code{TRUE} allows you to change
  default settings.  Notice that all connections should be closed
  before re-loading.
  }
}
\value{
An object of class \code{SQLiteDriver} which extends 
\code{dbDriver} and 
\code{dbObjectId}.
This object is required to create connections
to the embedded SQLite database.
There can be many SQLite database instances running
simultaneously.
}
\section{Side Effects}{
The R/S-Plus client part of the database communication is initialized,
but note that connecting to database instances needs to be done through
calls to \code{dbConnect}.
}
\details{
This object is a singleton, that is, on subsequent invocations
it returns the same initialized object. 

This implementation allows the R/S-Plus embedded SQLite engine
to work with multiple database instances through multiple connections 
simultaneously.

SQLite keeps each database instance in one single file. The name
of the database \emph{is} the file name, thus database names
should be legal file names in the running platform.
}
\section{User authentication}{
SQLite is a single-user database engine, so it has no concept of
a user.
}
\author{David A. James}
\section{References}{
See the Omega Project for Statistical Computing
at \url{http://www.omegahat.org} and \url{http://stat.bell-labs.com/RS-DBI}
for more details on the R/S-Plus database interface.

See the Adobe PDF file \code{DBI.pdf} under the \code{doc}
subdirectory of the DBI package, i.e., 
\code{system.file("doc", "DBI.pdf", package = "DBI")}

See the documentation at the SQLite Web site
\url{http://www.hwaci/com/sw/sqlite/index.html} for details.
}
\seealso{
On database drivers:

\code{\link[DBI]{dbDriver}}
\code{\link{SQLite}}
\code{\link[DBI]{dbUnloadDriver}}
\code{\link[DBI]{dbListConnections}}

On connections, SQL statements and resultSets:

\code{\link[DBI]{dbConnect}}
\code{\link[DBI]{dbDisconnect}}
\code{\link[DBI]{dbSendQuery}}
\code{\link[DBI]{dbGetQuery}}
\code{\link[DBI]{fetch}}
\code{\link[DBI]{dbListResults}}

On transaction management:

\code{\link[DBI]{dbCommit}}
\code{\link[DBI]{dbRollback}}

On meta-data:

\code{\link{summary}}
\code{\link[DBI]{dbGetInfo}}
\code{\link[DBI]{dbListTables}}
\code{\link[DBI]{dbListFields}}
\code{\link[DBI]{dbColumnsInfo}}
\code{\link[DBI]{dbGetException}}
\code{\link[DBI]{dbGetStatement}}
\code{\link[DBI]{dbHasCompleted}}
\code{\link[DBI]{dbGetRowCount}}
\code{\link[DBI]{dbGetAffectedRows}}
}
\examples{\dontrun{
   # create a SQLite instance and create one connection.
   m <- dbDriver("SQLite")
   
   # initialize a new database "base.dbms" in the current directory
   # and copy some data.frame from the base package into it
   
   con <- dbConnect(m, dbname = "base.dbms")
   data(USArrests)
   dbWriteTable(con, "USArrests", USArrests, overwrite = T)
   
   # query
   rs <- dbSendQuery(con, "select * from USArrests")
   d1 <- fetch(rs, n = 10)      # extract data in chunks of 10 rows
   dbHasCompleted(rs)
   d2 <- fetch(rs, n = -1)      # extract all remaining data
   dbHasCompleted(rs)
   dbClearResult(rs)
   dbListTables(con)    
   }
}
\keyword{interface}
\keyword{database}
% docclass is function
%  vim: syntax=tex
