% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_df.R
\name{classic.to.sym}
\alias{classic.to.sym}
\title{Generate a symbolic data frame}
\usage{
classic.to.sym(x = NULL, concept = NULL,
  variables = tidyselect::everything(), default.numeric = sym.interval,
  default.categorical = sym.modal, ...)
}
\arguments{
\item{x}{A data.frame.}

\item{concept}{These are the variable that we are going to use a concepts.}

\item{variables}{These are the variables that we want to include in the symbolic data table.}

\item{default.numeric}{function to use for numeric variables}

\item{default.categorical}{function to use for categorical variables}

\item{...}{A vector with names and the type of symbolic data to use, the available types are type_histogram (), type_continuous (), type.set (), type.modal (), by default type_histogram () is used for numeric variables and type_modal () for the categorical variables.}
}
\value{
a [tibble][tibble::tibble-package]
}
\description{
Generate a symbolic data table from a classic data table.
}
\references{
Bock H-H. and Diday E. (eds.) (2000).
Analysis of Symbolic Data. Exploratory methods for extracting statistical information from
complex data. Springer, Germany.
}
