% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{abalone}
\alias{abalone}
\title{SODAS XML data file.}
\format{abalone<-SODAS.to.RSDA('C:/Program Files (x86)/DECISIA/SODAS version 2.0/bases/abalone.xml)}
\source{
http://www.info.fundp.ac.be/asso/sodaslink.htm
}
\usage{
data(abalone)
}
\description{
Example of SODAS XML data file converted in a CSV file in RSDA format.
}
\examples{
data(abalone)
res<-sym.interval.pca(abalone,'centers')
class(res$Sym.Components) <- c('sym.data.table')
sym.scatterplot(res$Sym.Components[,1],res$Sym.Components[,2],
labels=TRUE,col='red',main='PCA Oils Data')
sym.scatterplot3d(res$Sym.Components[,1],res$Sym.Components[,2],
res$Sym.Components[,3],color='blue',main='PCA Oils Data')
sym.scatterplot.ggplot(res$Sym.Components[,1],
res$Sym.Components[,2],labels=TRUE)
sym.circle.plot(res$Sym.Prin.Correlations)
}
\references{
Bock H-H. and Diday E. (eds.) (2000).Analysis of Symbolic Data. Exploratory methods
for extracting statistical information fromcomplex data. Springer, Germany.
}
\keyword{datasets}
