% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.set.plot.R
\name{sym.set.plot}
\alias{sym.set.plot}
\title{Function for plotting one "set" type value from the symbolic data table}
\usage{
sym.set.plot(info, col = c("blue"), border = FALSE, show.type = TRUE,
  reduce = FALSE)
}
\arguments{
\item{info}{The information of one "set" type value. Use data[num.r,num.col] to get info}

\item{col}{A specification for the default plotting color.}

\item{border}{A logical value indicating whether border should be plotted.}

\item{show.type}{A logical value indicating whether type should be plotted.}

\item{reduce}{A logical value indicating whether values different from zero should be plotted in modal and set graphics.}
}
\value{
A plot of one "set" type value from the symbolic data table.
}
\description{
Function for plotting one "set" type value from the symbolic data table
}
\examples{
\dontrun{
data(ex1_db2so)
data.sym <- classic.to.sym(ex1_db2so, concept=c("state", "sex"),
                           variables=c("county", "group", "age","age","age","age"),
                           variables.types=c("$I", "$C", "$C", "$S", "$M","$H"))
sym.set.plot(data.sym[1,4])
sym.set.plot(data.sym[1,4], reduce = TRUE)
}
}
\author{
Andres Navarro
}
