% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.histogram.pca.R
\name{sym.histogram.pca}
\alias{sym.histogram.pca}
\title{Histogram Principal Components Analysis}
\usage{
sym.histogram.pca(sym.data, method = c('histogram', 'classic'))
}
\arguments{
\item{sym.data}{Symbolic data table.}

\item{method}{The method to be used.}
}
\value{
Return a symbolic data table.
}
\description{
This functions allows us to execute a histogram principal components analysis from a
symbolic data table with continuos, interval or histogram variables that can be mixed.
}
\examples{
data(example7)
res<-sym.histogram.pca(example7)
class(res) <- c('sym.data.table')
sym.scatterplot(res[,1],res[,2], labels=TRUE,col='red',main='Histogram PCA')
sym.scatterplot3d(res[,1],res[,2],res[,3],color='blue',
                  main='Histogram PCA')
}
\references{
Diday, E., Rodriguez O. and Winberg S. (2000).
Generalization of the Principal Components Analysis to Histogram
Data, 4th European Conference on Principles and Practice of Knowledge Discovery in Data
Bases, September 12-16, 2000, Lyon, France.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\seealso{
sym.interval.pca
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Histogram}
\keyword{PCA}
