% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.union.polygons}
\alias{rsaga.union.polygons}
\title{Spatial union of two polygon layers}
\usage{
rsaga.union.polygons(layer_a = NULL, layer_b = NULL, result = NULL,
  split = FALSE, load = FALSE, env = rsaga.env())
}
\arguments{
\item{layer_a}{A \code{character}-string representing the path to a polygon
shapefile or a spatial object of class
\link[sp:SpatialPolygons]{SpatialPolygonsDataFrame}.}

\item{layer_b}{A \code{character}-string representing the path to a polygon
shapefile or a spatial object of class
\link[sp:SpatialPolygons]{SpatialPolygonsDataFrame} with which to union layer_a.}

\item{result}{\code{character}, path indicating where to store the output
shapefile.}

\item{split}{If \code{TRUE}, multipart polygons become separated polygons
(default: FALSE).}

\item{load}{If \code{TRUE}, the resulting output shapefile will be loaded
into R (default: FALSE).}

\item{env}{RSAGA geoprocessing environment created by
\code{\link[=rsaga.env]{rsaga.env()}}, required because module(s) depend(s) on SAGA
version.}
}
\value{
The function saves the output shapefile to the path indicated in
function argument \code{result} and loads the resulting shapefile into R
when function parameter \code{load} is set to TRUE.
}
\description{
The function \code{rsaga.union.polygons} uses SAGA function
"\code{Union}" to calculate the geometric union of two polygon layers. This
corresponds to the intersection and the symmetrical difference of the two
layers.
}
\details{
Function \code{gUnion()} in \code{rgeos} package can also be used for joining
intersecting polygon geometries. However,
\code{\link[=rsaga.union.polygons]{rsaga.union.polygons()}} will be usually much faster,
especially when joining thousands of polygons.
}
\examples{
\dontrun{
library("RSAGA")
library("sp")
# construct coordinates of two squares
coords_1 <- matrix(data = c(0, 0, 1, 0, 1, 1, 0, 1, 0, 0),
                 ncol = 2, byrow = TRUE)
coords_2 <- matrix(data = c(-0.5, -0.5, 0.5, -0.5, 0.5, 0.5, -0.5, 0.5,
                            -0.5, -0.5),
                 ncol = 2, byrow = TRUE)
# convert the coordinates into polygons
poly_1 <- SpatialPolygons(list(Polygons(list(Polygon(coords_1)), 1)))
poly_1 <- SpatialPolygonsDataFrame(poly_1, data = data.frame(id = 1))
poly_2 <- SpatialPolygons(list(Polygons(list(Polygon(coords_2)), 1)))
poly_2 <- SpatialPolygonsDataFrame(poly_2, data = data.frame(id_2 = 2))
# union the two polygons using SAGA and load the output
dir_tmp <- paste0(tempdir(), "/out.shp")
res <- rsaga.union.polygons(layer_a = poly_1,
                            layer_b = poly_2,
                            result = dir_tmp,
                            load = TRUE)
# output attribute table consists of three elements, i.e. the union of poly_1
# and poly_2
dim(res)
res@data
}
}
\author{
Jannes Muenchow (R interface), Olaf Conrad and Angus Johnson (SAGA
modules)
}
\keyword{operations,}
\keyword{polygons}
\keyword{vector}
