% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.angles.R
\name{retrieve.angles}
\alias{retrieve.angles}
\title{Extracting a user-specified subset of the evo.dir results}
\usage{
retrieve.angles(angles.res,wishlist=c("anglesMRCA","angleDir","angles.between.species"),
  random=c("yes","no"),focus=c("node","species","both","none"),
 node=NULL,species=NULL,csvfile=NULL)
}
\arguments{
\item{angles.res}{the object resulting from \code{\link{evo.dir}} function.}

\item{wishlist}{specifies whether to extract angles and sizes
(\code{"anglesMRCA"}) of resultant vectors between individual species and
the MRCA, angles and sizes (\code{"angleDir"}) of vectors between individual
species and a fixed reference vector (the same for all species), or angles
between species resultant vectors (\code{"angles.between.species"}).}

\item{random}{it needs to be \code{"yes"} if \code{'angles.res'} object
contains randomization results.}

\item{focus}{it can be \code{"node"}, \code{"species"}, \code{"both"}, or
\code{"none"}, whether the user wants the results for a focal node, or for a
given species, for both, or just wants to visualize everything.}

\item{node}{must be indicated if \code{focus = "node"} or \code{"both"}. As
for \code{\link{evo.dir}}, the node number must refer to the dichotomic version of
the original tree, as produced by \code{\link{RRphylo}}.}

\item{species}{must be indicated if \code{focus = "species"} or \code{"both"}.}

\item{csvfile}{if results should be saved to a .csv file, a character
indicating the name of the csv file and the path where it is to be saved.
If no path is indicated the file is stored in the working directory.
If left unspecified, no file will be saved.}
}
\value{
\code{retrieve.angles} outputs an object of class \code{'data.frame'}.

If \code{wishlist = "anglesMRCA"}, the data frame includes:
 \itemize{\item\strong{MRCA} the most recent common ancestor the angle is
 computed to \item\strong{species} species ID \item\strong{angle} the angle
 between the resultant vector of species and the MRCA
 \item\strong{vector.size} the size of the resultant vector computed from
 species to MRCA }

If \code{wishlist = "angleDir"}, the data frame includes:
 \itemize{\item\strong{MRCA} the most recent common ancestor the vector is
 computed to \item\strong{species} species ID \item\strong{angle.direction}
 the angle between the vector of species and a fixed reference
 \item\strong{vector.size} the size of the vector of species }

If \code{wishlist = "angles.between.species"}, the data frame
 includes: \itemize{\item\strong{MRCA} the most recent common ancestor the
 vector is computed from \item\strong{species} pair IDs of the species pair
 the "angle between species" is computed for
 \item\strong{angleBTWspecies2MRCA} angle between species resultant vectors
 to MRCA \item\strong{anglesBTWspecies} angle between species resultant
 vectors }
}
\description{
This function takes the result list produced by
 \code{\link{evo.dir}} as the input, and extracts a specific subset of it.
 The user may specify whether to extract the set of angles between species
 resultant vectors and the MRCA, the size of resultant vectors, or the set of
 angles between species.
}
\details{
\code{retrieve.angles} allows to focalize the extraction to a
 particular node, species, or both. Otherwise it returns the whole dataset.
}
\examples{
\dontrun{
    data("DataApes")
    DataApes$PCstage->PCstage
    DataApes$Tstage->Tstage

    cc<- 2/parallel::detectCores()
    RRphylo(tree=Tstage,y=PCstage,clus=cc)->RRstage

# Case 1. "evo.dir" without performing randomization
    evo.dir(RRstage,angle.dimension="rates",pair.type="node",
    node=  57,random="no")->ed1

 # Case 1.1 angles and sizes of resultant vectors between individual species and the MRCA:
  # for a focal node
    retrieve.angles(ed1,wishlist="anglesMRCA",random="no",focus="node",
    node=68)->ra1
  # for a focal species
    retrieve.angles(ed1,wishlist="anglesMRCA",random="no",focus="species",
    species="Sap")->ra2
  # for both focal node and species
    retrieve.angles(ed1,wishlist="anglesMRCA",random="no",focus="both",
    node=68,species="Sap")->ra3
  # without any specific requirement
    retrieve.angles(ed1,wishlist="anglesMRCA",random="no",focus="none")->ra4

 # Case 1.2 angles and sizes of vectors between individual species
 #and a fixed reference vector:
  # for a focal node
    retrieve.angles(ed1,wishlist="angleDir",random="no",focus="node",
    node=68)->ra5
  # for a focal species
    retrieve.angles(ed1,wishlist="angleDir",random="no",focus="species",
    species="Sap")->ra6
  # for both focal node and species
    retrieve.angles(ed1,wishlist="angleDir",random="no",focus="both",
    node=68,species="Sap")->ra7
  # without any specific requirement
    retrieve.angles(ed1,wishlist="angleDir",random="no",focus="none")->ra8

 # Case 1.3 angles between species resultant vectors:
  # for a focal node
    retrieve.angles(ed1,wishlist="angles.between.species",random="no",
    focus="node", node=68)->ra9
  # for a focal species
    retrieve.angles(ed1,wishlist="angles.between.species",random="no",
    focus="species", species="Sap")->ra10
  # for both focal node and species
    retrieve.angles(ed1,wishlist="angles.between.species",random="no",
    focus="both",node=68,species="Sap")->ra11
  # without any specific requirement
    retrieve.angles(ed1,wishlist="angles.between.species",random="no",
    focus="none")->ra12


# Case 2. "evo.dir" with performing randomization
    evo.dir(RRstage,angle.dimension="rates",pair.type="node",node=57,
    random="yes",nrep=10)->ed7

 # Case 2.1 angles and sizes of resultant vectors between individual species and the MRCA:
  # for a focal node
    retrieve.angles(ed7,wishlist="anglesMRCA",random="yes",focus="node",
    node=68)->ra13
  # for a focal species
    retrieve.angles(ed7,wishlist="anglesMRCA",random="yes", focus="species",
    species="Sap")->ra14
  # for both focal node and species
    retrieve.angles(ed7,wishlist="anglesMRCA",random="yes",focus="both",
    node=68,species="Sap")->ra15
  # without any specific requirement
    retrieve.angles(ed7,wishlist="anglesMRCA",random="yes",focus="none")->ra16

 # Case 2.2 angles and sizes of vectors between individual species and a fixed reference vector:
  # for a focal node
    retrieve.angles(ed7,wishlist="angleDir",random="yes",focus="node",
    node=68)->ra17
  # for a focal species
    retrieve.angles(ed7,wishlist="angleDir",random="yes",focus="species",
    species="Sap")->ra18
  # for both focal node and species
    retrieve.angles(ed7,wishlist="angleDir",random="yes",focus="both",
    node=68, species="Sap")->ra19
  # without any specific requirement
    retrieve.angles(ed7,wishlist="angleDir",random="yes",focus="none")->ra20

 # Case 2.3 retrieve angles between species resultant vectors:
  # for a focal node
    retrieve.angles(ed7,wishlist="angles.between.species",random="yes",
    focus="node", node=68)->ra21
  # for a focal species
    retrieve.angles(ed7,wishlist="angles.between.species",random="yes",
    focus="species", species="Sap")->ra22
  # for both focal node and species
    retrieve.angles(ed7,wishlist="angles.between.species",random="yes",
    focus="both",node=68,species="Sap")->ra23
  # without any specific requirement
    retrieve.angles(ed7,wishlist="angles.between.species",random="yes",
    focus="none")->ra24
    }
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
 Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
 Carotenuto
}
