% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrend.R
\name{plotTrend}
\alias{plotTrend}
\title{Graphical representation of search.trend results}
\usage{
plotTrend(ST)
}
\arguments{
\item{ST}{an object produced by \code{\link{search.trend}}.}
}
\value{
The function returns a list of functions:

\strong{$plotPhen} returns the plot of rescaled phenotype versus age
 regression. The 95\% confidence intervals of slopes produced by regressing
 phenotypes simulated under the Brownian motion are plotted as a shaded area.

\strong{$plotRates} returns the plot of log rescaled rates versus age
 regression. The 95\% confidence intervals of slopes produced by regressing
 rates simulated under the Brownian motion are plotted as a shaded area.

\strong{$plotPhenNode} returns plots of rescaled phenotype versus age
 regression for individual clades. For each plot, the gray line represents
 the slope of phenotype versus age regression for the rest of the tree.

\strong{$plotRatesNode} returns plots of absolute rates versus age
 regression for individual clades. For each plot, the gray line represents
 the slope of absolute rates versus age regression for the rest of the tree.
}
\description{
This function generates customized functions to produce plots of
 phenotype versus time and absolute evolutionary rates versus time
 regressions for the entire phylogeny and individual clades. Each custom
 function takes as the only argument the index or name of the variable (as
 in the \code{search.trend} output in \code{$trends.data$phenotypeVStime}) to be plotted.
}
\examples{
 \dontrun{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino
cc<- 2/parallel::detectCores()

# Extract Pterosaurs tree and data
library(ape)
extract.clade(treedino,746)->treeptero
massdino[match(treeptero$tip.label,names(massdino))]->massptero
massptero[match(treeptero$tip.label,names(massptero))]->massptero

RRphylo(tree=treeptero,y=log(massptero))->RRptero

search.trend(RR=RRptero, y=log(massptero), nsim=100, node=143, clus=cc,cov=NULL)->ST

plotTrends(ST)->plotST

plotST$plotPhen(1) # to plot phenotypic trend through time for entire tree
plotST$plotPhen("y") # equivalent to the previuous line

plotST$plotRates(1) # to plot rates trend through time for entire tree

plotST$plotPhenNode("y") # to plot phenotypic trend through time for the clade
plotST$plotRatesNode("y") # to plot rates trend through time for the clade

   }
}
\references{
Castiglione, S., Serio, C., Mondanaro, A., Di Febbraro, M.,
 Profico, A., Girardi, G., & Raia, P. (2019) Simultaneous detection of
 macroevolutionary patterns in phenotypic means and rate of change with and
 within phylogenetic trees including extinct species. \emph{PLoS ONE}, 14:
 e0210101. https://doi.org/10.1371/journal.pone.0210101
}
\seealso{
\href{../doc/search.trend.html}{\code{search.trend} vignette}
}
\author{
Silvia Castiglione, Carmela Serio, Pasquale Raia
}
