% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rrtest}
\alias{rrtest}
\title{Generic residual randomization test}
\usage{
rrtest(model, g_invar, num_R = 999, alpha = 0.05,
  val_type = "decision")
}
\arguments{
\item{model}{Regression model and hypothesis. See \link{example_model} for details.}

\item{g_invar}{Stochastic function that transforms residuals. Accepts n-vector and returns n-vector.}

\item{num_R}{Number of test statistic values to calculate in the randomization test.}

\item{alpha}{Nominal test level (between 0 to 1).}

\item{val_type}{The type of return value.}
}
\value{
If \code{val_type} = "decision" (default) we get the test binary decision (1=REJECT H0).

If \code{val_type} = "pval" we get the test p-value.

If  \code{val_type} = "full" we get the full test output, i.e., a \code{List} with elements \code{tobs}, \code{tvals},
the observed and randomization values of the test statistic, respectively.
}
\description{
This function tests the specified linear hypothesis in \code{model} assuming the errors are distributionally invariant
with respect to stochastic function \code{g_invar}.
}
\details{
For the regression y = X * beta + e, this function is testing the following linear null hypothesis:

        H0: lam' beta = lam[1] * beta[1] + ... + lam[p] * beta[p] = lam0,

where y, X, lam, lam0 are specified in \code{model}.
The assumption is that the errors, e, have some form of cluster invariance.
Specifically:

(e_1, e_2, ..., e_n) ~  g_invar(e_1, e_2, ..., e_n),

where ~ denotes equality in distribution, and \code{g_invar} is the supplied
invariance function.
}
\note{
There is no guarantee that an arbitrary \code{g_invar} will produce valid tests.
The \link{rrtest_clust} function has such guarantees under mild assumptions.
}
\examples{
model = example_model(n = 100)  # test H0: beta2 = 0 (here, H0 is true)
g_invar = function(e) sample(e)   # Assume errors are exchangeable.
rrtest(model, g_invar) # same as rrtest_clust(model, "perm")

}
\seealso{
Life after bootstrap: residual randomization inference in regression models (Toulis, 2019)

\url{https://sites.google.com/view/panos-toulis/residual-randomization}
}
