% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfluenceFunctions_R.R
\name{IF}
\alias{IF}
\title{Influence Function for Available Risk Measures}
\usage{
IF(risk, returns = NULL, evalShape = FALSE, retVals = NULL,
  nuisPars = NULL, k = 4, IFplot = FALSE, IFprint = TRUE,
  compile = TRUE, prewhiten = FALSE, ar.prewhiten.order = 1,
  cleanOutliers = FALSE, cleanMethod = c("locScaleRob", "Boudt")[1],
  eff = 0.99, alpha.robust = 0.05, ...)
}
\arguments{
\item{risk}{Risk measure.}

\item{returns}{Vector of the returns of the asset or portfolio.}

\item{evalShape}{Evaluation of the shape of the IF risk measure if TRUE. Otherwise, a TS of the IF of the provided returns is computed.}

\item{retVals}{Values used to evaluate the shape of the IF.}

\item{nuisPars}{Nuisance parameters used for the evaluation of the shape of the IF (if no returns are provided).}

\item{k}{Range parameter for the shape of the IF (the SD gets multiplied k times).}

\item{IFplot}{If TRUE, the plot of the IF shape or IF TS of the returns is produced.}

\item{IFprint}{If TRUE, the data for the IF shape or the IF TS of the returns is returned.}

\item{compile}{Boolean variable to indicate if the IF TS should be computed using compiled code (C++) (TRUE) or not (FALSE).}

\item{prewhiten}{Boolean variable to indicate if the IF TS is pre-whitened (TRUE) or not (FALSE).}

\item{ar.prewhiten.order}{Order of AR parameter for the pre-whitening. Default is AR(1).}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the IF TS should be done through a robust filter.}

\item{cleanMethod}{Robust method used to clean outliers from the TS. The choices are "Boudt" and "locScaleRob" for the function.}

\item{eff}{Tuning parameter for the normal distribution efficiency for the "locScaleRob" robust data cleaning.}

\item{alpha.robust}{Tuning parameter for the quantile of the "Boudt" robust data cleaning algorithm, using the minimum covariance determinant estimator (MCD).}

\item{...}{Additional parameters passed on to influence function of risk measure.}
}
\description{
\code{IF} returns the data and plots the shape of either the IF or the IF TS for a risk measure specified.
}
\examples{
# Plot of IF using the wrapper function
outIF <- IF(risk="mean",
            returns=NULL, evalShape=TRUE, retVals=NULL, nuisPars=list(mu=0.005),
            IFplot=TRUE, IFprint=TRUE)

#' # Loading data (hedge funds returns)
data(edhec, package="PerformanceAnalytics")
colnames(edhec) = c("CA", "CTAG", "DIS", "EM","EMN", "ED", "FIA",
                    "GM", "LS", "MA", "RV", "SS", "FoF") 
                    
# Plot of IF using wrapper function and with a specified TS 
outIF <- IF(risk="mean",
            returns=edhec[,"CA"], evalShape=TRUE, 
            retVals=seq(-0.1, 0.1, by=0.001), nuisPars=NULL,
            IFplot=TRUE, IFprint=TRUE)

# Computing the IF of the returns (with outlier cleaning and prewhitening) with a plot of IF TS
outIF <- IF(risk="mean",
            returns=edhec[,"CA"], evalShape=FALSE, retVals=NULL, nuisPars =NULL,
            IFplot=TRUE, IFprint=TRUE,
            compile=TRUE, prewhiten=FALSE,
            cleanOutliers=TRUE, cleanMethod=c("locScaleRob", "Boudt")[1], eff=0.99)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
