% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpdtest.R
\name{rpdStat}
\alias{rpdStat}
\title{Randomized phi-divergence test: statistic part}
\usage{
rpdStat(data, probability, lambda = 1, nDim, r)
}
\arguments{
\item{data}{the same data structure that provided in \link{rpdTest}.}

\item{probability}{the same numeric vector that provided in \link{rpdTest}.}

\item{lambda}{the same parameter that provided in \link{rpdTest}.}

\item{nDim}{an integer indicating the dimension of the uniformly
distributed vectors generated during the computation of the statistic.
It is equal to the number of experiments for the multinomial distribution.}

\item{r}{an integer indicating the dimension of the data parameter.
It is equal to the number of possible outcomes of the multinomial distribution.}
}
\value{
a numeric value that reflects the statistic obtained after
an execution of rpdTest at that time.
}
\description{
This is one of the auxiliary functions used to execute the rpdTest function.
This function calculates the statistic for a single  Randomized
phi-divergence test. Users generally do not need to call this function
except for testing purposes.
}
\examples{
d <- c(20,40)
#The next line is equivalent to rpdTest(d)$statistic

rpdStat(d, c(1/2,1/2), nDim = sum(d), r = length(d))

}
