% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ListProjectParam.R
\name{ListProjectParam}
\alias{ListProjectParam}
\title{List Optimizely entities}
\usage{
ListProjectParam(project.id, param = "G")
}
\arguments{
\item{project.id}{identifier for project.}

\item{param}{Identifies the entity to list
 \itemize{
\item G - Goals
\item A - Audiences
\item T - Targeting list (as on June 2015 user lists is part of paid feature. Confirm if you have access to user lists)
\item D - Dimensions
}}
}
\value{
data frame - of goals/audiences/targeting lists/dimensions in a project
}
\description{
Query Optimizely API to get project entities listed in a project
 \itemize{
\item Goals
\item Audiences
\item Targeting list
\item Dimensions
}
}
\examples{
\dontrun{
# Information for an dimension
# Use set_token to assign account token
# set_token('123456789101112:zzzzz')
# Lists all audiences in a project
final.df<-ListProjectParam('1234567',param='A')

# Lists goals in a project (default)
final.df<-ListProjectParam('1234567')
}
}
\seealso{
\code{\link{GetProjectList}}
}

