% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.rspd_matrix.R
\name{rspd_matrix}
\alias{rspd_matrix}
\title{rspd_matrix}
\usage{
rspd_matrix(d, n = 1, sort_eigenvalues = TRUE, gen = stats::rexp)
}
\arguments{
\item{d}{[integer] Dimension of the matrix}

\item{n}{[integer] numbers of samples drawn}

\item{sort_eigenvalues}{[bool] If eigen values (i.e. variance) are sorted}

\item{gen}{[function] Eigenvalues generator}
}
\value{
[array or matrix], dim = d * d * n or d * d if n == 1
}
\description{
Generate a random symetric positive definite matrix. The generator just
draw matrix of the form O * diag(positive values) * t(O), where O is an
orthogonal matrix from ROOPSD::rorthogonal_group. Note that the parameter
gen = stats::rexp draw positive eigen values, but the code do not control
if eigen values are positive. So you can accept negative eigen values using
another generators.
}
\examples{
mean = stats::runif( n = 2 , min = -5 , max = 5 )
cov  = ROOPSD::rspd_matrix(2)
X    = ROOPSD::rmultivariate_normal( 10000 , mean , cov )

}
