% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{Q_constraint}
\alias{Q_constraint}
\alias{as.Q_constraint}
\alias{is.Q_constraint}
\alias{length.Q_constraint}
\alias{terms.Q_constraint}
\alias{variable.names.Q_constraint}
\title{Quadratic Constraints}
\usage{
Q_constraint(Q, L, dir, rhs, names = NULL)

\method{variable.names}{Q_constraint}(object, ...)

as.Q_constraint(x)

is.Q_constraint(x)

\method{length}{Q_constraint}(x)

\method{terms}{Q_constraint}(x, ...)
}
\arguments{
\item{Q}{a list of (sparse) matrices representing the quadratic
part of each constraint.}

\item{L}{a numeric vector of length \eqn{n} (a single constraint)
or a matrix of dimension \eqn{n \times m}, where \eqn{n} is the
number of objective variables and \eqn{m} is the number of
constraints. Matrices can be of class
\code{"simple_triplet_matrix"} to allow a sparse representation of
constraints.}

\item{dir}{a character vector with the directions of the
constraints. Each element must be one of \code{"<="}, \code{">="} or \code{"=="}.}

\item{rhs}{a numeric vector with the right hand side of the
constraints.}

\item{names}{an optional character vector giving the names of \eqn{x}
(row/column names of \eqn{Q}, column names of \eqn{A}).}

\item{object}{an R object.}

\item{...}{further arguments passed to or from other methods
(currently ignored).}

\item{x}{an R object.}
}
\value{
an object of class \code{"Q_constraint"} which inherits
from \code{"constraint"}.
}
\description{
Quadratic constraints are typically of the form
\deqn{\frac{1}{2}x^{\top}Q_ix + L_i x \leq rhs_i}
where \eqn{Q_i} is the \eqn{i}th of \eqn{m} (sparse) matrices 
(all of dimension \eqn{n \times n}) giving the coefficients of the quadratic
part of the equation. The \eqn{m \times n} (sparse) matrix \eqn{L}
holds the coefficients of the linear part of the equation and \eqn{L_i} 
refers to the \eqn{i}th row. The right hand side of the constraints 
is represented by the vector \eqn{rhs}.
}
\author{
Stefan Theussl
}

