% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getUniqueNode.R
\name{getUniqueNode}
\alias{getUniqueNode}
\title{Retrieve Nodes by Label and Property}
\usage{
getUniqueNode(graph, .label, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{.label}{A character string.}

\item{...}{A named list. A key = value pair by which the node label is uniquely constrained.}
}
\value{
A node object.
}
\description{
Retrieve a single node from the graph by specifying its label and unique key = value pair.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

createNode(graph, "Person", name = "Alice")
createNode(graph, "Person", name = "Bob")

addConstraint(graph, "Person", "name")

getUniqueNode(graph, "Person", name = "Alice")
}
}
\seealso{
\code{\link{getLabeledNodes}}
}

