% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrNNGpois.R
\name{CorrNNGpois}
\alias{CorrNNGpois}
\title{Adjusts the Target Correlation}
\usage{
CorrNNGpois(theta.vec, lambda.vec, r)
}
\arguments{
\item{theta.vec}{rate parameters in the generalized Poisson distribution. It is assumed that the
length of the vector is at least two, and each value has to be a positive number.}

\item{lambda.vec}{dispersion parameters in the generalized Poisson distribution. It is assumed that the length
of the vector is at least two. All lambda values have to be < 1. For lambda < 0, lambda must be >= -theta/4.}

\item{r}{desired target correlation.}
}
\value{
the adjusted target correlation.
}
\description{
\code{CorrNNGpois} adjusts the actual/realized correlation to the target correlation bounds for
a pair of generalized Poisson variables.
}
\examples{
\donttest{
 CorrNNGpois(c(0.1,10), c(0.1, 0.2),0.5)
 CorrNNGpois(c(0.1,10), c(-0.01, -0.02),0.5)
 CorrNNGpois(c(4,2.3), c(-0.32,-0.3),0.7)
 CorrNNGpois(c(14,10), c(-0.8, -0.3),0.99)}
}
\references{
Yahav, I. and Shmueli, G.(2012), On generating multivariate Poisson data in management science applications.
 \emph{Applied Stochastic Models in Business and Industry}, \bold{28(1)}, 91-102.
}
