% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_plotCrit.R
\name{plotCrit}
\alias{plotCrit}
\title{Plot BIC and ICL}
\usage{
plotCrit(output, pkg = c("ggplot2", "plotly"), ...)
}
\arguments{
\item{output}{\emph{MixtCompLearn} object}

\item{pkg}{"ggplot2" or "plotly". Package used to plot}

\item{...}{arguments to be passed to plot_ly}
}
\description{
Plot BIC and ICL
}
\examples{
data(simData)
 
# define the algorithm's parameters
algo <- createAlgo()

# keep only 3 variables
model <- simData$model$unsupervised[c("Gaussian1", "Poisson1", "Categorical1")]

# run RMixtComp in unsupervised clustering mode + data as matrix
res <- mixtCompLearn(simData$dataLearn$matrix, model, algo, nClass = 2:4)

# plot
plotCrit(res)

}
\seealso{
Other plot: \code{\link{plot.MixtCompLearn}}
}
\author{
Quentin Grimonprez
}
\concept{plot}
