\name{merge_design.covariates}
\alias{merge.design.covariates}
\alias{merge_design.covariates}
\title{Merge time (occasion) and/or group specific covariates into design data}
\usage{
  merge_design.covariates(ddl, df, bygroup = FALSE,
    bytime = TRUE)
}
\arguments{
  \item{ddl}{current design dataframe for a specific
  parameter and not the entire design data list (ddl); see
  example below}

  \item{df}{dataframe with time(occasion) and/or
  group-specific data}

  \item{bygroup}{logical; if TRUE, then a field named
  \code{group} should be in \code{df} and the values can
  then be group specific.}

  \item{bytime}{logical; if TRUE, then a field named
  \code{time} should be in \code{df} and the values can
  then be time specific.}
}
\value{
  Design dataframe (for a particular parameter) with new
  fields added. See \code{\link{make.design.data}} for a
  description of the design data list structure. The return
  value is only one element in the list rather than the
  entire list as with the older function
  \code{merge.occasion.data}.
}
\description{
  Adds new design data fields from a dataframe into a
  design data list (\code{ddl}) by matching via time and/or
  group field in the design data.
}
\details{
  Design data can be added to the parameter specific design
  dataframes with R commands.  This function simplifies the
  process by enabling the merging of a dataframe with a
  time and/or group field and one or more time and/or group
  specific covariates into the design data list for a
  specific model parameter. This is a replacement for the
  older function \code{merge.occasion.data}. Unlike the
  older function, it uses the R function
  \code{\link{merge}} but before merging it makes sure all
  of the fields exist and that you are not merging data
  that already exists in the design data.  It also
  maintains the row names in the case where design data
  have been deleted prior to merging the design covariate
  data.

  If \code{bytime=TRUE},the dataframe \code{df} must have a
  field named \code{time} that matches 1-1 for each value
  of \code{time} in the design data list (\code{ddl}).  All
  fields in \code{df} (other than time/group) are added to
  the design data.  If you set \code{bygroup=TRUE} and have
  a field named \code{group} in \code{df} and its values
  match the group fields in the design data then
  group-specific values can be assigned for each time if
  \code{bytime=TRUE}. If \code{bygroup=TRUE} and
  \code{bytime=FALSE} then it matches by group and not by
  time.
}
\examples{
data(dipper)
dipper.proc=process.data(dipper)
ddl=make.design.data(dipper.proc)
df=data.frame(time=c(1:7),effort=c(10,5,2,8,1,2,3))
# note that the value for time 1 is superfluous for CJS but not for POPAN
# the value 10 will not appear in the summary because there is no p for time 1
summary(ddl$p)
ddl$p=merge_design.covariates(ddl$p,df)
summary(ddl$p)
\donttest{
#
# Assign group-specific values
#
dipper.proc=process.data(dipper,groups="sex")
dipper.ddl=make.design.data(dipper.proc)
df=data.frame(group=c(rep("Female",6),rep("Male",6)),time=rep(c(2:7),2),
  effort=c(10,5,2,8,1,2,3,20,10,4,16,2))
merge_design.covariates(dipper.ddl$p,df,bygroup=TRUE)
}
}
\author{
  Jeff Laake
}
\seealso{
  \code{\link{make.design.data}},
  \code{\link{process.data}}, \code{\link{add.design.data}}
}
\keyword{utility}

