% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_czek_matrix.R
\name{print.czek_matrix_dist}
\alias{print.czek_matrix_dist}
\title{Prints information concerning Czekanowski's Diagram}
\usage{
\method{print}{czek_matrix_dist}(x, print_raw = FALSE, ...)
}
\arguments{
\item{x}{a matrix with class czek_matrix_dist.}

\item{print_raw}{logical, if TRUE print out raw, as if base::print() was called, in particular this prints out the matrix itself, if FALSE (default) print out a summary. Furthermore, with print_raw=TRUE the attributes "levels", "partition_boundaries" and "n_classes" defining the diagram will be printed out.}

\item{...}{specifies further parameters that can be passed on to the print function.}
}
\value{
The function returns a Czekanowski's Diagram.
}
\description{
This is a function that prints out information on a Czekanowski's Diagram, but when the actual distances were saved.
}
\examples{
# Set data ####
x<-czek_matrix(mtcars,as_dist=TRUE)


# Standard print ############
print(x)
print.czek_matrix(x)
# Print out the raw object ############
print(x,print_raw=TRUE)
print.czek_matrix(x,print_raw=TRUE)
}
