% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPCorpusStats.R
\name{corpusStats,KorAPConnection-method}
\alias{corpusStats,KorAPConnection-method}
\alias{corpusStats}
\title{Fetch information about a (virtual) corpus}
\usage{
\S4method{corpusStats}{KorAPConnection}(kco, vc = "", verbose = kco@verbose, as.df = FALSE)
}
\arguments{
\item{kco}{\code{\link[=KorAPConnection]{KorAPConnection()}} object (obtained e.g. from \code{new("KorAPConnection")}}

\item{vc}{string describing the virtual corpus. An empty string (default) means the whole corpus, as far as it is license-wise accessible.}

\item{verbose}{logical. If \code{TRUE}, additional diagnostics are printed.}

\item{as.df}{return result as data frame instead of as S4 object?}
}
\value{
\code{KorAPCorpusStats} object with the slots \code{documents}, \code{tokens}, \code{sentences}, \code{paragraphs}
}
\description{
Fetch information about a (virtual) corpus
}
\examples{
\donttest{corpusStats(new("KorAPConnection"))}

kco <- new("KorAPConnection")
corpusStats(kco, "pubDate in 2017 & articleType=/Zeitung.*/")

}
