#' Read ImageJ Region of Interest (ROI) files
#' 
#' Provides functions to read ImageJ (http://imagej.nih.gov/ij/) Region of Interest (ROI) files, to plot the ROIs and to convert them as spatstat (http://spatstat.org/) spatial patterns.
#' 
#' ImageJ ROI objects can be read to R using \code{\link{read.ijroi}} and \code{\link{read.ijzip}} functions. The objects can be plotted using generic \code{\link[=plot.ijroi]{plot}} command and converted to \link{spatstat.geom} spatial patterns by using \code{\link{ij2spatstat}} function.
#'
#' @name RImageJROI
#' @docType package
#' @import spatstat
NULL
