/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.util.Properties;

public class ProxySettings
implements PlugIn {
    private static Properties props = System.getProperties();
    private String proxyhost = Prefs.get("proxy.server", "");
    private int proxyport = (int)Prefs.get("proxy.port", 8080.0);
    private String proxyuser = Prefs.get("proxy.user", "");
    private String proxypass = "";
    private boolean authenticate;

    public void run(String arg) {
        String pass;
        String user;
        double portNumber;
        String port;
        if (IJ.getApplet() != null) {
            return;
        }
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            this.proxyhost = host;
        }
        if ((port = System.getProperty("http.proxyPort")) != null && !Double.isNaN(portNumber = Tools.parseDouble(port))) {
            this.proxyport = (int)portNumber;
        }
        if ((user = System.getProperty("http.proxyUser")) != null) {
            this.proxyuser = user;
        }
        if ((pass = System.getProperty("http.proxyPassword")) != null) {
            this.proxypass = pass;
        }
        if (!this.showDialog()) {
            return;
        }
        if (!this.proxyhost.equals("")) {
            props.put("proxySet", "true");
        } else {
            props.put("proxySet", "false");
        }
        props.put("http.proxyHost", this.proxyhost);
        props.put("http.proxyPort", "" + this.proxyport);
        props.put("http.proxyUser", this.proxyuser);
        props.put("http.proxyPassword", this.proxypass);
        Prefs.set("proxy.server", this.proxyhost);
        Prefs.set("proxy.port", this.proxyport);
        Prefs.set("proxy.user", this.proxyuser);
        if (IJ.debugMode) {
            IJ.log("proxy set: " + System.getProperty("proxySet"));
            IJ.log("proxy host: " + System.getProperty("http.proxyHost"));
            IJ.log("proxy port: " + System.getProperty("http.proxyPort"));
            IJ.log("proxy username: " + System.getProperty("http.proxyUser"));
            IJ.log("proxy password: " + System.getProperty("http.proxyPassword"));
        }
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Proxy Settings");
        gd.addStringField("Proxy Server:", this.proxyhost, 15);
        gd.addNumericField("Port:", this.proxyport, 0);
        gd.addCheckbox(" Authenticate", this.authenticate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.proxyhost = gd.getNextString();
        this.proxyport = (int)gd.getNextNumber();
        this.authenticate = gd.getNextBoolean();
        if (this.authenticate && !this.proxyhost.equals("")) {
            GenericDialog gd2 = new GenericDialog("Authentication");
            gd2.setInsets(0, 0, 12);
            gd2.addMessage("Enter user name and password for proxy server");
            gd2.addStringField("User:", this.proxyuser, 12);
            gd2.setEchoChar('*');
            gd2.addStringField("Password:", this.proxypass, 12);
            gd2.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.proxyuser = gd2.getNextString();
            this.proxypass = gd2.getNextString();
        } else {
            this.proxyuser = "";
            this.proxypass = "";
        }
        return true;
    }
}

