/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Clipboard
implements PlugIn,
Transferable {
    static java.awt.datatransfer.Clipboard clipboard;

    public void run(String arg) {
        if (IJ.altKeyDown()) {
            if (arg.equals("copy")) {
                arg = "scopy";
            } else if (arg.equals("paste")) {
                arg = "spaste";
            }
        }
        if (arg.equals("copy")) {
            this.copy(false);
        } else if (arg.equals("paste")) {
            this.paste();
        } else if (arg.equals("cut")) {
            this.copy(true);
        } else if (arg.equals("scopy")) {
            this.copyToSystem();
        } else if (arg.equals("showsys")) {
            this.showSystemClipboard();
        } else if (arg.equals("show")) {
            this.showInternalClipboard();
        }
    }

    void copy(boolean cut) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.copy(cut);
        } else {
            IJ.noImage();
        }
    }

    void paste() {
        if (ImagePlus.getClipboard() == null) {
            this.showSystemClipboard();
        } else {
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.paste();
            } else {
                this.showInternalClipboard();
            }
        }
    }

    void setup() {
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    void copyToSystem() {
        this.setup();
        try {
            clipboard.setContents(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void showSystemClipboard() {
        this.setup();
        IJ.showStatus("Opening system clipboard...");
        try {
            Transferable transferable = clipboard.getContents(null);
            boolean imageSupported = transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
            boolean textSupported = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!imageSupported && IJ.isMacOSX() && this.displayMacImage(transferable)) {
                return;
            }
            if (imageSupported) {
                Image img = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                if (img == null) {
                    IJ.error("Unable to convert image on system clipboard");
                    IJ.showStatus("");
                    return;
                }
                int width = img.getWidth(null);
                int height = img.getHeight(null);
                BufferedImage bi = new BufferedImage(width, height, 1);
                Graphics2D g = bi.createGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                WindowManager.checkForDuplicateName = true;
                new ImagePlus("Clipboard", bi).show();
            } else if (textSupported) {
                String text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (IJ.isMacintosh()) {
                    text = Tools.fixNewLines(text);
                }
                Editor ed = new Editor();
                ed.setSize(600, 300);
                ed.create("Clipboard", text);
                IJ.showStatus("");
            } else {
                IJ.error("Unable to find an image on the system clipboard");
            }
        }
        catch (Throwable e) {
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            e.printStackTrace(pw);
            new TextWindow("Exception", caw.toString(), 350, 250);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageProcessor ip;
            if (imp.isComposite()) {
                ip = new ColorProcessor(imp.getImage());
                ip.setRoi(imp.getRoi());
            } else {
                ip = imp.getProcessor();
            }
            ip = ip.crop();
            int w = ip.getWidth();
            int h = ip.getHeight();
            IJ.showStatus(w + "x" + h + " image copied to system clipboard");
            Image img = IJ.getInstance().createImage(w, h);
            Graphics g = img.getGraphics();
            g.drawImage(ip.createImage(), 0, 0, null);
            g.dispose();
            return img;
        }
        return null;
    }

    void showInternalClipboard() {
        ImagePlus clipboard = ImagePlus.getClipboard();
        if (clipboard != null) {
            ImageProcessor ip = clipboard.getProcessor();
            ImagePlus imp2 = new ImagePlus("Clipboard", ip.duplicate());
            Roi roi = clipboard.getRoi();
            imp2.killRoi();
            if (roi != null && roi.isArea() && roi.getType() != 0) {
                roi = (Roi)roi.clone();
                roi.setLocation(0, 0);
                imp2.setRoi(roi);
                IJ.run(imp2, "Clear Outside", null);
                imp2.killRoi();
            }
            WindowManager.checkForDuplicateName = true;
            imp2.show();
        } else {
            IJ.error("The internal clipboard is empty.");
        }
    }

    boolean displayMacImage(Transferable t) {
        Image img = this.getMacImage(t);
        if (img != null) {
            WindowManager.checkForDuplicateName = true;
            new ImagePlus("Clipboard", img).show();
        }
        return img != null;
    }

    Image getMacImage(Transferable t) {
        if (!this.isQTJavaInstalled()) {
            return null;
        }
        Image img = null;
        DataFlavor[] d = t.getTransferDataFlavors();
        if (d == null || d.length == 0) {
            return null;
        }
        try {
            Object is = t.getTransferData(d[0]);
            if (is == null || !(is instanceof InputStream)) {
                return null;
            }
            img = this.getImageFromPictStream((InputStream)is);
        }
        catch (Exception e) {
            // empty catch block
        }
        return img;
    }

    Image getImageFromPictStream(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = new byte[512];
            byte[] buf = new byte[4096];
            int retval = 0;
            int size = 0;
            baos.write(header, 0, 512);
            while ((retval = is.read(buf, 0, 4096)) > 0) {
                baos.write(buf, 0, retval);
            }
            baos.close();
            size = baos.size();
            if (size <= 0) {
                return null;
            }
            byte[] imgBytes = baos.toByteArray();
            Class<?> c = Class.forName("quicktime.QTSession");
            Method m = c.getMethod("isInitialized", null);
            Boolean b = (Boolean)m.invoke(null, null);
            if (!b.booleanValue()) {
                m = c.getMethod("open", null);
                m.invoke(null, null);
            }
            c = Class.forName("quicktime.util.QTHandle");
            Constructor<?> con = c.getConstructor(imgBytes.getClass());
            Object handle = con.newInstance(new Object[]{imgBytes});
            String s = new String("PICT");
            c = Class.forName("quicktime.util.QTUtils");
            m = c.getMethod("toOSType", s.getClass());
            Integer type = (Integer)m.invoke(null, s);
            c = Class.forName("quicktime.std.image.GraphicsImporter");
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            con = c.getConstructor(classArray);
            Object importer = con.newInstance(type);
            m = c.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            m.invoke(importer, handle);
            m = c.getMethod("getNaturalBounds", null);
            Object rect = m.invoke(importer, null);
            c = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            con = c.getConstructor(importer.getClass());
            Object iDrawer = con.newInstance(importer);
            m = rect.getClass().getMethod("getWidth", null);
            Integer width = (Integer)m.invoke(rect, null);
            m = rect.getClass().getMethod("getHeight", null);
            Integer height = (Integer)m.invoke(rect, null);
            Dimension d = new Dimension(width, height);
            c = Class.forName("quicktime.app.view.QTImageProducer");
            con = c.getConstructor(iDrawer.getClass(), d.getClass());
            Object producer = con.newInstance(iDrawer, d);
            if (producer instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)producer);
            }
        }
        catch (Exception e) {
            IJ.showStatus("QuickTime for java error");
        }
        return null;
    }

    boolean isQTJavaInstalled() {
        boolean isInstalled = false;
        try {
            Class<?> c = Class.forName("quicktime.QTSession");
            isInstalled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInstalled;
    }
}

