% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceMethods.R
\docType{methods}
\name{getGraphSpace,GraphSpace-method}
\alias{getGraphSpace,GraphSpace-method}
\alias{getGraphSpace}
\title{Accessors for fetching slots from a GraphSpace object}
\usage{
\S4method{getGraphSpace}{GraphSpace}(gs, what = "summary")
}
\arguments{
\item{gs}{A preprocessed \linkS4class{GraphSpace} class object}

\item{what}{A single character value specifying which information should 
be retrieved from the slots.
Options: 'graph','gxy','gxyz','pars','misc','status','summits',
'summit_mask', and 'summit_contour'.}
}
\value{
Content from slots in the \linkS4class{GraphSpace} object.
}
\description{
\code{getGraphSpace} retrives information from
individual slots available in a GraphSpace object.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a new GraphSpace object
gs <- GraphSpace(gtoy1)

# Get the 'summary' slot in gs
getGraphSpace(gs, what = 'summary')

}
