% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls8Search.R
\name{ls8Search}
\alias{ls8Search}
\title{Search Landsat-8 images}
\usage{
ls8Search(AppRoot, verbose = FALSE, precise = FALSE, ...)
}
\arguments{
\item{AppRoot}{directory of the metadata file.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{precise}{logical argument. If \code{TRUE}, conducts a thorough search,
tile by tile (slower).}

\item{...}{arguments for nested functions:
 \itemize{
  \item \code{dates} a vector with the capturing dates being searched. This
   argument is mandatory if \code{startDate} and \code{endDate} are not defined.
  \item \code{startDate} a \code{Date} class object with the starting date of the 
study period. This argument is mandatory if 
  \code{dates} is not defined.
  \item \code{endDate} a \code{Date} class object with the ending date of the 
study period. This argument is mandatory if 
  \code{dates} is not defined.
  \item \code{region} a \code{Spatial*}, projected \code{raster*}, or 
  \code{sf} class object defining the area of interest. This argument is
  mandatory if \code{pathrow}, \code{extent}, or \code{lonlat} are not defined.
  \item \code{pathrow} a \code{list} of vectors with the path and row numbers
  of the tiles concerning the region of interest. This argument is mandatory
  if \code{region}, \code{extent}, or \code{lonlat} are not provided. Ex. 
  \code{list(c(200,31),c(200,30))}.
  \item \code{lonlat} a vector with the longitude/latitude coordinates of the
  point of interest. Ex. \code{c(-1.64323,42.81687)}.
  \item \code{extent} an \code{extent}, \code{Raster*}, or 
  \code{Spatial*} object representing the region of interest with 
  longitude/latitude coordinates. This argument is mandatory if 
  \code{region}, \code{pathrow}, or \code{lonlat} are not defined.
  \item column names in the .LS8MD \code{data.frame} and their values.
}}
}
\value{
a \code{data.frame} with the name of the images and their metadata.
}
\description{
\code{ls8Search} searches Landsat-8 images in the Landsat repository concerning
a particular location and date interval. The function returns a 
\code{data.frame} with the names of the images and their metadata.
}
\details{
\code{ls8Search} searches images in the metadata file. If the metadata was
downloaded before to the current directory, \code{ls8Search} will use this
metadata by default. In case the metadata was not downloaded yet, 
\code{ls8Search} will make that call for you. The function creates the
following subfolders "Landsat-8/metadata", where the metadata file is
located.

Landsat images are organized by tiles, which have a unique path and row
numbers according to the
\href{https://landsat.gsfc.nasa.gov/the-worldwide-reference-system/}{Worldide Reference System}.
The fastest way to search an image in the metadata file is by path and row
(\code{pathrow}). This method requires to know in advance the path and row
number of the tile that is relevant for your region of interest. From the
user's standpoint, the simplest way to search a time series of Landsat-7
images is by \code{region}, \code{extent}, or \code{lonlat} since they do
not require any prior knowledge about tiles.

The function can screen the results by any other attribute in the metadata.
For instance, to filter the imagery with an available preview, the 
\code{browseAvaliable=”Y”} must be added as an argument of the function
(see the examples).
}
\examples{
\dontrun{
# search by path and row numbers of a tile
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
sres <- ls8Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                  endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                  pathrow = list(c(200, 31), c(200, 30)),
                  browseAvaliable = "Y",
                  AppRoot = wdir)

# search by extent (long/lat coordinates)
# load a spatial polygon object of Navarre
data(ex.navarre)
sres <- ls8Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                  endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                  extent = ex.navarre,
                  precise = TRUE,
                  browseAvaliable = "Y",
                  AppRoot = wdir)

# search by extent (fast mode)
sres <- ls8Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                  endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                  extent = ex.navarre,
                  precise = FALSE,
                  browseAvaliable = "Y",
                  AppRoot = wdir)
# remove metadata to free memory space
lsRemoveMetadata()
}
}
