% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls8FolderToVar.R
\name{ls8FolderToVar}
\alias{ls8FolderToVar}
\title{Compute a remote sensing index from a time series of Landsat-8 images}
\usage{
ls8FolderToVar(src, fun, AppRoot, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{path to the folder with the Landsat-8 multispectral image.}

\item{fun}{a \code{function} that computes the remote sensing index.}

\item{AppRoot}{the directory of the outcoming time series.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series of
images as a \code{RasterStack}, otherwise the images are saved in the Hard
Drive Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{...}{arguments for nested functions.
 \itemize{
  \item \code{dates} a vector with the capturing dates being considered
  for mosaicking. If not supplied, all dates are mosaicked.
}}
}
\value{
this function does not return anything, unless \code{getStack = TRUE}
which then returns a \code{RasterStack} with the time series of with the
index.
}
\description{
\code{ls8FolderToVar} computes a remote sensing index from the spectral bands
of a time series of Landsat-8 images. The images are specified by the path to
the folder that stores the imagery (resulting from the \code{\link{lsMosaic}} 
function). The function returns a \code{RasterStack} with a time series of 
images of the remote sensing index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{lsMosaic}}.The \code{fun} argument can be any function from this
package beginning with “var” (\code{\link{varNDVI}}, \code{\link{varEVI}},
etc.). Custom functions can also be implemented. If \code{fun = varRGB}, 
then the argument \code{getStack} must be equal to \code{FALSE} and the 
red-green-blue (RGB) images must be imported afterwards.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
# download Landsat-8 images
lsDownSearch(satellite = "ls8",
             username = "username",
             password = "password",
             startDate = as.Date("01-01-2018","\%d-\%m-\%Y"),
             endDate = as.Date("18-01-2018","\%d-\%m-\%Y"),
             pathrow = list(c(200, 31), c(200, 30)),
             untar = TRUE,
             AppRoot = wdir)
# folder with the Landsat-8 untared images
src.ls8 <-file.path(wdir,"Landsat8")
src.ls8.untar <- file.path(src.ls8, "untar")
# mosaic the Landsat-8 images
lsMosaic(src = src.ls8.untar,
         AppRoot = src.ls8,
         out.name = "Navarre",
         extent = ex.navarre,
         gutils = TRUE)
# path to the folder with mosaicked images
src.ls8.navarre <- file.path(src.ls8, "Navarre")
# generate NDVI images of Navarre
src.ls8.var <- file.path(src.ls8, "Navarre_Variables")
dir.create(src.ls8.var)
ls8FolderToVar(src.ls8.navarre,
               fun = varNDVI,
               AppRoot = src.ls8.var,
               overwrite = TRUE)
               
files.ls8.ndvi <- list.files(file.path(src.ls8.var,"NDVI"),
                             pattern = "\\\\.tif$",
                             full.names = TRUE,
                             recursive = TRUE)

img.ls8.ndvi <- raster(files.ls8.ndvi[1])
spplot(img.ls8.ndvi)
}
}
