% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varNDVI.R
\name{varNDVI}
\alias{varNDVI}
\title{Calculate the normalized difference vegetation index (NDVI)}
\usage{
varNDVI(red, nir)
}
\arguments{
\item{red}{a \code{raster} with the red band of the capture.}

\item{nir}{a \code{raster} with the NIR band of the capture.}
}
\value{
A NDVI image in \code{raster} format.
}
\description{
\code{varNDVI} computes the normalized difference vegetation index (NDVI)
from the red an near-infrared (NIR) bands.
}
\details{
The normalized difference vegetation index (NDVI) is the most widely used 
index for monitoring vegetation dynamics. The NDVI reflex vegetation vigour
and it is closed related to the amount of photosynthetically active radiation
absorbed \insertCite{rouse1972monitoring}{RGISTools}. This function is used
within \code{\link{ls7FolderToVar}}, \code{\link{ls8FolderToVar}},
\code{\link{modFolderToVar}} and \code{\link{senFolderToVar}}.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
img.dir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
img.files <- list.files(img.dir, pattern="\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")

# select the red and NIR bands
red <- raster(img.files[1])
nir <- raster(img.files[2])
# calculate the NDVI image
ndvi <- varNDVI(red,nir)
# plot the image
spplot(ndvi,col.regions=rev(terrain.colors(20)))
}
\references{
\insertRef{rouse1972monitoring}{RGISTools}
}
