% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modDownSearch.R
\name{modDownSearch}
\alias{modDownSearch}
\title{Download MODIS images from a search list}
\usage{
modDownSearch(searchres, AppRoot, username = NULL, password = NULL,
  overwrite = FALSE, ...)
}
\arguments{
\item{searchres}{the output from the \code{\link{modSearch}} function.}

\item{AppRoot}{the directory where the images will be saved.}

\item{username}{NASA’s `EarthData' username.}

\item{password}{NASA’s `EarthData' password.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{...}{argument for nested functions:}
}
\description{
\code{modDownSearch} downloads the images from a list of uniform resource 
locator (URL) generated by the \code{\link{modSearch}} function from NASA’s
`EartData' plataform. The images are saved as GTiff files in the 
\code{AppRoot} directory.
}
\details{
\code{modDownSearch} is able to download MODIS Terra and Aqua products.
These products are published in the 
\href{https://earthdata.nasa.gov}{`EarthData' Platform}.
The platform is supported by the Earth Observing System Data and Information
System (EODIS) and managed NASA’s Earth Science Data Systems (ESDS).
\code{modDownSearch} requires credentianls from an `EarthData' account to
access the NASA’s web data service, which can be obtained 
\href{https://urs.earthdata.nasa.gov/users/new}{here}.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
mList <- modSearch(product = "MYD13A2",
                   startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                   endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                   collection = 6,
                   extent = ex.navarre)
head(mList)
# download the first image in mList
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
src.mod <- file.path(src,"Modis","MYD13A2")
src.mod.hdf <- file.path(src.mod,"hdf")
modDownSearch(mList[1], 
              username = "user", 
              password = "pass",
              AppRoot = src.mod.hdf)
# download all images in mList
modDownSearch(mList, 
              username = "user", 
              password = "pass",
              AppRoot = src.mod.hdf)
}
}
