% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls8FolderToVar.R
\name{ls8FolderToVar}
\alias{ls8FolderToVar}
\title{Compute a remote sensing index from a time series of Landsat-8 images}
\usage{
ls8FolderToVar(src, fun, AppRoot, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{path to the folder with the Landsat-8 multispectral image.}

\item{fun}{is a function that computes the remote sensing index.}

\item{AppRoot}{the directory of the outcoming time series.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series of
images as a \code{RasterStack}, otherwise the images are saved in the Hard
Drive Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\value{
this function does not return anything, unless \code{getStack = TRUE}
and then it returns a \code{RasterStack} with the time series of with the
index.
}
\description{
\code{ls8FolderToVar} computes a remote sensing index from the spectral bands
of a time series of Landsat-8 images. The images are specified by the path to
the folder that stores the imagery (resulting from the \code{\link{lsMosaic}} 
function). The function returns a \code{RasterStack} with a time series of 
images with the index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{lsMosaic}}.The \code{fun} argument can be any function from this
package beginning with “var” (\code{\link{varNDVI}}, \code{\link{varEVI}},
etc.). Custom functions can also be implemented. If \code{fun = varRGB}, 
then the argument \code{getStack} must be equal to \code{FALSE} and the 
red-green-blue (RGB) images must be imported afterwards.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
# download Landsat-8 images
lsDownload(satellite = "ls8",
           username = "username",
           password = "password",
           startDate = as.Date("01-01-2018","\%d-\%m-\%Y"),
           endDate = as.Date("18-01-2018","\%d-\%m-\%Y"),
           pathrow = list(c(200, 31), c(200, 30)),
           untar = TRUE,
           AppRoot = src)
# folder with the Landsat-8 untared images
src.ls8 <-file.path(src,"Landsat8")
tif.src <- file.path(src.ls8, "untar")
# mosaic the Landsat-8 images
lsMosaic(src = tif.src,
         AppRoot = src.ls8,
         out.name = "Navarre",
         extent = ex.navarre,
         gutils = TRUE)
# path to the folder with mosaicked images
src2 <- file.path(src.ls8, "Navarre")
# generate NDVI images of Navarre
src3 <- file.path(src.ls8, "Navarre_Variables")
dir.create(src3)
ls8FolderToVar(src2,
               fun = varNDVI,
               AppRoot = src3,
               overwrite = TRUE)
               
flist <- list.files(file.path(src3,"NDVI"),
                    pattern = "\\\\.tif$",
                    full.names = TRUE,
                    recursive = TRUE)

file.raster <- raster(flist[1])
spplot(file.raster)
}
}
