% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_corr.R
\name{baseline_corr}
\alias{baseline_corr}
\title{Two-dimensional baseline correction}
\usage{
baseline_corr(chromatogram, ...)
}
\arguments{
\item{chromatogram}{a \emph{raw_GCxGC} object.}

\item{...}{other parameters passed to \code{\link[ptw]{baseline.corr}}
function in the pwt package.}
}
\description{
`baseline_corr` provides a two-dimensional baseline correction
by using the asymmetric least squares algorithm.
}
\details{
This function takes a raw two-dimensional chromatogram and performs
 the baseline correction  with the implemented function in
 \code{\link[ptw]{baseline.corr}}  \insertCite{Eilers2004}{RGCxGC}.
}
\examples{
library(colorRamps)
chrom_name <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
chrom_2D <- read_chrom(chrom_name, 5L)
chrom_bsline <- baseline_corr(chrom_2D)
plot(chrom_bsline, nlevels = 150,
           color.palette = matlab.like)

}
\references{
\insertAllCited{}
}
