% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{indicator}
\alias{indicator}
\title{Indicators fo CUBS}
\format{
A list with 53 nested country lists with time series objects. Each country list contains 3 time series variables:
\describe{
  \item{serv}{Confidence indicator in the service industry.}
  \item{buil}{Confidence indicator in the bulding and construction industry.}
  \item{indu}{Capacity utilization in manufacturing/industry.}
  }
}
\source{
\url{https://economy-finance.ec.europa.eu/economic-forecast-and-surveys/business-and-consumer-surveys_en}
}
\usage{
indicator
}
\description{
A dataset containing the service sector confidence indicator, the construction sector confidence indicator and the capacity utilization in manufacturing/industry.
}
\details{
A dataset containing the seasonally adjusted utilization indicators in the service industry, the building and construction industry,
and capacity utilization in manufacturing/industry for all EU countries and some neighboring countries at different frequencies.

The confidence indicator in the service industry is composed of question 1, 2, and 3 of the monthly service sector survey  ((Q1 + Q2 + Q3)/3).
The underlying survey questions are as follows:
 \itemize{
  \item Q1 Business situation development over the past 3 months
  \item Q2 Evolution of the demand over the past 3 months
  \item Q3 Expectation of the demand over the next 3 months
}
The confidence indicator in the building and construction industry is composed of question 3 and 4 of the monthly building and construction sector survey  ((Q3 and Q4)/2).
The underlying survey questions are as follows:
 \itemize{
  \item Q3 Evolution of your current overall order books
  \item Q4 Employment expectations over the next 3 months
}
The indicator for capacity utilization in manufacturing/industry is based on question 13 of the quarterly industry sector survey.
The underlying survey question is as follows:
 \itemize{
  \item Q3 Current level of capacity utilization
}
}
\keyword{datasets}
