% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_ts.R
\name{hpfilter}
\alias{hpfilter}
\title{HP filter}
\usage{
hpfilter(x, lambda)
}
\arguments{
\item{x}{A univariate time series object.}

\item{lambda}{The smoothing parameter.}
}
\value{
A univariate time series object containing the trend of the original time series.
}
\description{
Applies the Hodrick Prescott Filter.
}
\examples{
# get data for France
data("gap")
country <- "France"
tsList <- amecoData2input(gap[[country]], alpha = 0.65)
hp <- hpfilter(x = tsList$gdp, lambda = 6.25)
}
