% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{.initializeVar}
\alias{.initializeVar}
\title{Initializes variance restrictions.}
\usage{
.initializeVar(
  model,
  type = NULL,
  lambda = NULL,
  prior = FALSE,
  errorARMA = c(0, 0),
  q = 0.05
)
}
\arguments{
\item{model}{An object of class \code{NAWRUmodel}, \code{TFPmodel}, or \code{KuttnerModel}.}

\item{type}{The variance restriction type. Possible options are \code{"basic"},
\code{"hp"}, see details. The default is \code{type = "basic"}.}

\item{lambda}{The smoothing constant for the HP-filter if \code{type = "hp"}.}

\item{prior}{A logical indicating whether prior parameters should be returned.}

\item{errorARMA}{The ARMA order of the second equation error process.}

\item{q}{Quantile for the Inverse Gamma distribution (only used if \code{type = "hp"}). The 
default is \code{q = 0.01}.}
}
\description{
Initializes variance restrictions.
}
\keyword{internal}
