% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubs.R
\name{cubs}
\alias{cubs}
\title{CUBS indicator}
\usage{
cubs(tsCU, tsVA, frequency = 1, lambda = NULL)
}
\arguments{
\item{tsCU}{A multiple time series containing three survey time series, the first
element needs to be capacity utilization in industry, see details. Alternatively, a list
of time series can be supplied.}

\item{tsVA}{A multiple time series containing three value added series that correspond to
\code{tsCU}. Alternatively, a list of time series can be supplied.}

\item{frequency}{The frequency of the computed cubs indicator. Possible entries are
\code{frequency = 1} (annual), \code{frequency = 4} (quarterly). The default is
\code{frequency = 1}.}

\item{lambda}{The smoothing parameter for the application of the HP filter (see details).
If not supplied, \code{lambda = 6.25} is used for yearly data and \code{lambda = 1600} 
for quarterly data.}
}
\value{
A list containing the two time series capacity utilization in industry \code{cu}
 and the CUBS indicator \code{cubs}.
}
\description{
Computes the capacity utilization economic sentiment (CUBS) indicator.
}
\details{
The list \code{tslCU} contains capacity utilization in industry, and the relevant
  survey outcomes of the construction and service sector. The first list object needs to
  contain capacity utilization in industry.

The list \code{tslVA} contains the real value added series for the industry,
  construction and service sector in the same order as \code{tslCU}.

The computed CUBS indicator consists exclusively of capacity utilization in
  industry until both other series become available.
}
\examples{
# load data for Germany
data("gap")
country <- "Germany"

# compute cubs indicator
namesCubs <- c("indu", "serv", "buil")
namesVACubs <- paste0("va", namesCubs)
tscubs <- cubs(
  tsCU = gap[[country]][, namesCubs],
  tsVA = gap[[country]][, namesVACubs]
)
}
