/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class TwoMax
extends AbstractStaticSingleObjectiveFitnessFunction {
    int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();

    public TwoMax(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        BitSet result = ((BitStringGenotype)genotype).getBitSet();
        return Math.abs(this.dimension / 2 - result.cardinality()) + this.dimension / 2;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension() / 2;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return "The fitness value of an individual I is the number of ones in its genotype if there are more ones than zeros in the genotype and the fitness value is the number of zeros if there are more zeros than ones in the genotype.\n\nTwoMax(I) = |n/2 - u| + n/2\n\nwith n: the dimension of the Search Space\nu: the number of ones in the genotype of I";
    }

    public String getName() {
        return "TwoMax";
    }
}

